//
//  MCClientServerEndpoint.h
//  MCClientServer
//
//  Created by Brent Gulanowski on 10-02-08.
//  Copyright 2010 Marketcircle Inc. All rights reserved.
//


#import <MCNetComm/MCEndpoint.h>

#import <MCClientServer/MCClientServerDefines.h>


@class MCPDatabaseConnection;

@interface MCAccessdEndpoint : MCEndpoint {

	NSString *databaseName;
	NSString *username;
	NSString *clientUUID;
	
	MCPDatabaseConnection *conn;	
}

- (NSString *)databaseName;
- (void)setDatabaseName:(NSString *)aDatabaseName;
- (NSString *)username;
- (void)setUsername:(NSString *)anUsername;
- (NSString *)clientUUID;
- (void)setClientUUID:(NSString *)newClientUUID;

- (MCPDatabaseConnection *)connection;
- (void)setConnection:(MCPDatabaseConnection *)aConn;

// Authorization and verification
- (MCSAuthorizationResultCode)verifyAuthorizationVersion:(NSNumber *)version;
- (MCSAuthorizationResultCode)verifyDatabase:(NSString *)dbName identifier:(NSString **)puuid;
- (MCSAuthorizationResultCode)verifyClientSchema:(NSNumber *)clientSchema forDatabase:(NSString *)dbName;
- (MCSAuthorizationResultCode)authorizeUser:(NSString *)login password:(NSString *)pass database:(NSString *)dbName;
- (MCSAuthorizationResultCode)verifyReplica:(BOOL)isMirror;

// Subclassers can override this method to do additional non-generic processing using the provided payload dictionary, and appending (if applicable) to the supplied response dictionary
- (MCSAuthorizationResultCode)additionalAuthorizationValidation: (NSDictionary*)payload response: (NSMutableDictionary*)response;

// temporary
- (void)handle_authorization_request:(NSDictionary *)payload;


@end
